/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item.tool;

import cofh.core.enchantment.CoFHEnchantment;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class ItemBowAdv
extends ItemBow {
    protected IIcon[] normalIcons = new IIcon[4];
    protected Item.ToolMaterial toolMaterial;
    public String repairIngot = "";
    public float arrowSpeedMultiplier = 2.0f;
    public float arrowDamageMultiplier = 1.25f;
    protected boolean showInCreative = true;

    public ItemBowAdv(Item.ToolMaterial toolMaterial) {
        this.toolMaterial = toolMaterial;
        this.setMaxDamage(toolMaterial.getMaxUses());
    }

    public int cofh_canEnchantApply(ItemStack itemStack, Enchantment enchantment) {
        if (enchantment.effectId == Enchantment.looting.effectId) {
            return 1;
        }
        if (enchantment.type == EnumEnchantmentType.bow) {
            return 1;
        }
        return -1;
    }

    public ItemBowAdv setRepairIngot(String string) {
        this.repairIngot = string;
        return this;
    }

    public ItemBowAdv setArrowSpeed(float f) {
        this.arrowSpeedMultiplier = f;
        return this;
    }

    public ItemBowAdv setArrowDamage(float f) {
        this.arrowDamageMultiplier = f;
        return this;
    }

    public ItemBowAdv setShowInCreative(boolean bl) {
        this.showInCreative = bl;
        return this;
    }

    public void getSubItems(Item item, CreativeTabs creativeTabs, List list) {
        if (this.showInCreative) {
            list.add(new ItemStack(item, 1, 0));
        }
    }

    public int getItemEnchantability() {
        return this.toolMaterial.getEnchantability();
    }

    public boolean getIsRepairable(ItemStack itemStack, ItemStack itemStack2) {
        return ItemHelper.isOreNameEqual(itemStack2, this.repairIngot);
    }

    public boolean isFull3D() {
        return true;
    }

    public boolean isItemTool(ItemStack itemStack) {
        return true;
    }

    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        ArrowNockEvent arrowNockEvent = new ArrowNockEvent(entityPlayer, itemStack);
        MinecraftForge.EVENT_BUS.post((Event)arrowNockEvent);
        if (arrowNockEvent.isCanceled()) {
            return arrowNockEvent.result;
        }
        if (entityPlayer.capabilities.isCreativeMode || entityPlayer.inventory.hasItem(Items.arrow) || EnchantmentHelper.getEnchantmentLevel((int)Enchantment.infinity.effectId, (ItemStack)itemStack) > 0) {
            entityPlayer.setItemInUse(itemStack, this.getMaxItemUseDuration(itemStack));
        }
        return itemStack;
    }

    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer entityPlayer, int n) {
        boolean bl;
        int n2 = this.getMaxItemUseDuration(itemStack) - n;
        ArrowLooseEvent arrowLooseEvent = new ArrowLooseEvent(entityPlayer, itemStack, n2);
        MinecraftForge.EVENT_BUS.post((Event)arrowLooseEvent);
        if (arrowLooseEvent.isCanceled()) {
            return;
        }
        n2 = arrowLooseEvent.charge;
        boolean bl2 = bl = entityPlayer.capabilities.isCreativeMode || EnchantmentHelper.getEnchantmentLevel((int)Enchantment.infinity.effectId, (ItemStack)itemStack) > 0;
        if (bl || entityPlayer.inventory.hasItem(Items.arrow)) {
            float f = (float)n2 / 20.0f;
            if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
                f = 1.0f;
            } else if (f < 0.1f) {
                return;
            }
            int n3 = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.power.effectId, (ItemStack)itemStack);
            int n4 = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.punch.effectId, (ItemStack)itemStack);
            int n5 = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.flame.effectId, (ItemStack)itemStack);
            int n6 = EnchantmentHelper.getEnchantmentLevel((int)CoFHEnchantment.multishot.effectId, (ItemStack)itemStack);
            EntityArrow entityArrow = new EntityArrow(world, (EntityLivingBase)entityPlayer, f * this.arrowSpeedMultiplier);
            double d = entityArrow.getDamage() * (double)this.arrowDamageMultiplier;
            entityArrow.setDamage(d);
            if (f == 1.0f) {
                entityArrow.setIsCritical(true);
            }
            if (n3 > 0) {
                entityArrow.setDamage(d + (double)n3 * 0.5 + 0.5);
            }
            if (n4 > 0) {
                entityArrow.setKnockbackStrength(n4);
            }
            if (n5 > 0) {
                entityArrow.setFire(100);
            }
            if (bl) {
                entityArrow.canBePickedUp = 2;
            } else {
                entityPlayer.inventory.consumeInventoryItem(Items.arrow);
            }
            world.playSoundAtEntity((Entity)entityPlayer, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (ServerHelper.isServerWorld(world)) {
                world.spawnEntityInWorld((Entity)entityArrow);
            }
            for (int i = 0; i < n6; ++i) {
                entityArrow = new EntityArrow(world, (EntityLivingBase)entityPlayer, f * this.arrowSpeedMultiplier);
                entityArrow.setThrowableHeading(entityArrow.motionX, entityArrow.motionY, entityArrow.motionZ, 1.5f * f * this.arrowSpeedMultiplier, 3.0f);
                entityArrow.setDamage(d);
                if (f == 1.0f) {
                    entityArrow.setIsCritical(true);
                }
                if (n3 > 0) {
                    entityArrow.setDamage(d + (double)n3 * 0.5 + 0.5);
                }
                if (n4 > 0) {
                    entityArrow.setKnockbackStrength(n4);
                }
                if (n5 > 0) {
                    entityArrow.setFire(100);
                }
                entityArrow.canBePickedUp = 2;
                if (!ServerHelper.isServerWorld(world)) continue;
                world.spawnEntityInWorld((Entity)entityArrow);
            }
            if (!entityPlayer.capabilities.isCreativeMode) {
                itemStack.damageItem(1, (EntityLivingBase)entityPlayer);
            }
        }
    }

    public IIcon getIconIndex(ItemStack itemStack) {
        return this.getIcon(itemStack, 0);
    }

    public IIcon getIcon(ItemStack itemStack, int n) {
        return this.normalIcons[0];
    }

    public IIcon getIcon(ItemStack itemStack, int n, EntityPlayer entityPlayer, ItemStack itemStack2, int n2) {
        if (n2 > 0) {
            int n3 = itemStack.getMaxItemUseDuration() - n2;
            if (n3 > 17) {
                return this.normalIcons[3];
            }
            if (n3 > 13) {
                return this.normalIcons[2];
            }
            if (n3 > 0) {
                return this.normalIcons[1];
            }
        }
        return this.normalIcons[0];
    }

    public void registerIcons(IIconRegister iIconRegister) {
        this.normalIcons[0] = iIconRegister.registerIcon(this.getIconString());
        for (int i = 1; i < 4; ++i) {
            this.normalIcons[i] = iIconRegister.registerIcon(this.getIconString() + "_" + (i - 1));
        }
    }
}

